#!/bin/bash
#
# A cron job script for downloading custom node announcements with error reporting 
#
# This is intended to be run from cron every 8 hours and will randomly insert a delay from 0-8 hours
#
#  Copyright 2018 Bryan Fields
#  Licensed under the GNU GPLv2



URL="rsync://rsync.allstarlink.org/connect-messages"
FILEPATH="/var/lib/asterisk/sounds/rpt/nodenames"

#sleep for a random time of 0-28800 seconds (8 hours)
sleep $[ ( $RANDOM % 28799 )  + 1 ]s

#assign the filesUpdated var with the number of files changed by rsync.  This is nasty, but it works.

filesUpdated=`rsync -a --stats $URL $FILEPATH |grep "Number of regular files transferred" | cut -c 38-50`
exitcode=$?
if [ "$exitcode" = "0" ]; then
    if [ "$filesUpdated" = "0" ]; then
	echo "NodeNameUpdate run with no updates"
	logger -i "NodeNameUpdate run with no updates"
    elif [ "$filesUpdated" > "0" ]; then
	echo "NodeNameUpdate updated $filesUpdated nodenames"
        logger -i "NodeNameUpdate updated $filesUpdated nodenames" 
    fi
else
    echo "NodeNameUpdate failed"
    logger -i "NodeUpdate failed"
    exit 1
fi
exit 0
