#!/bin/bash
#
# A cron job script for downloading the extnodes file with error reporting
# 
#
# This is intended to be run from cron every 5 min
#  Copyright 2018 Bryan Fields
#  Licensed under the GNU GPLv2



URL="http://nodes.regsvcs.allstarlink.org/cgi-bin/gennodes.php"
FILEPATH=/var/lib/asterisk

#sleep for a random time of 0-300 seconds
sleep $[( $RANDOM % 299 )  + 1 ]s


# use curl in silent and compressed mode, connect timeout of 5 and
# -f for fail with an error code of 22 on server errors
#-m 20 is a max time for the whole process of 20 seconds
curl -s --compressed --connect-timeout 5 -f -m 20 -o /tmp/rpt_extnodes-temp $URL
exitcode=$?
if [ "$exitcode" = "0" ]; then
    grep -q extnodes /tmp/rpt_extnodes-temp
        if [ $? -eq "0" ] ;then
            chmod 700 /tmp/rpt_extnodes-temp
            cp /tmp/rpt_extnodes-temp $FILEPATH/rpt_extnodes-temp
            mv -f $FILEPATH/rpt_extnodes-temp $FILEPATH/rpt_extnodes
            whenandwhere=`grep "Generated at" /tmp/rpt_extnodes-temp |cut -c2-100`
            #don't print out on good run
	    #echo "NodeUpdate installed a new nodes list $whenandwhere"
	    logger -i "NodeUpdate installed a new nodes list $whenandwhere"
        else
            echo "NodeUpdate failed to parse node list; node list not updated"
	    logger -i "NodeUpdate failed to parse node list; node list not updated"
            exit 1
        fi

else
    echo "NodeUpdate could not get nodes list from server"
    logger -i "NodeUpdate could not get nodes list from server"
    exit 1
fi
exit 0
